/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.api.common.data.IAimInfo;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import java.util.function.Supplier;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.util.LazyOptional;

public class AimAnimation
implements IAnimation {
    private final IKeyframeProvider provider;
    private final Supplier<Float> progressSupplier;
    private float progress;
    private float progressO;
    private float progressI;
    private long ticksPlaying;

    public AimAnimation(IKeyframeProvider provider) {
        this.provider = provider;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        LazyOptional<IPlayerData> optional = PlayerData.get((PlayerEntity)player);
        if (optional.isPresent()) {
            IAimInfo aim = ((IPlayerData)optional.orElse(null)).getAimInfo();
            this.progressSupplier = aim::getProgress;
        } else {
            this.progressSupplier = () -> Float.valueOf(0.0f);
        }
    }

    @Override
    public void animate(AnimationStage stage, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        IKeyframe frame = this.provider.getCurrentFrame(stage, this.progressI, 0);
        Keyframes.processFrame(frame, this.progressI, matrixStack);
    }

    @Override
    public void gameTick() {
        this.progressO = this.progress;
        this.progress = this.progressSupplier.get().floatValue();
        ++this.ticksPlaying;
    }

    @Override
    public void renderTick(float deltaRenderTime) {
        this.progressI = AnimationUtils.linearInterpolate(this.progress, this.progressO, deltaRenderTime);
    }

    @Override
    public boolean hasFinished() {
        return this.progressI == 0.0f && this.ticksPlaying >= 100L;
    }
}

